%------------------------------------------------------------------------------
% File     : ITP096^1 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Liouville_Numbers problem prob_235__5867912_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Liouville_Numbers/prob_235__5867912_1 [Des21]

% Status   : ContradictoryAxioms
% Rating   : 0.56 v9.1.0, 0.62 v9.0.0, 0.70 v8.2.0, 0.54 v8.1.0, 0.64 v7.5.0
% Syntax   : Number of formulae    :  391 ( 235 unt;  41 typ;   0 def)
%            Number of atoms       :  822 ( 462 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 2129 (  91   ~;  32   |;  39   &;1779   @)
%                                         (   0 <=>; 188  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   18 (   5 avg)
%            Number of types       :    5 (   4 usr)
%            Number of type conns  :   64 (  64   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   39 (  37 usr;  13 con; 0-3 aty)
%            Number of variables   :  603 (  16   ^; 575   !;  12   ?; 603   :)
% SPC      : TH0_CAX_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 15:41:36.471
%------------------------------------------------------------------------------
% Could-be-implicit typings (4)
thf(ty_n_t__Set__Oset_It__Real__Oreal_J,type,
    set_real: $tType ).

thf(ty_n_t__Real__Oreal,type,
    real: $tType ).

thf(ty_n_t__Nat__Onat,type,
    nat: $tType ).

thf(ty_n_t__Int__Oint,type,
    int: $tType ).

% Explicit typings (37)
thf(sy_c_Groups_Oabs__class_Oabs_001t__Int__Oint,type,
    abs_abs_int: int > int ).

thf(sy_c_Groups_Oabs__class_Oabs_001t__Real__Oreal,type,
    abs_abs_real: real > real ).

thf(sy_c_Groups_Ominus__class_Ominus_001t__Int__Oint,type,
    minus_minus_int: int > int > int ).

thf(sy_c_Groups_Ominus__class_Ominus_001t__Nat__Onat,type,
    minus_minus_nat: nat > nat > nat ).

thf(sy_c_Groups_Ominus__class_Ominus_001t__Real__Oreal,type,
    minus_minus_real: real > real > real ).

thf(sy_c_Groups_Oone__class_Oone_001t__Int__Oint,type,
    one_one_int: int ).

thf(sy_c_Groups_Oone__class_Oone_001t__Nat__Onat,type,
    one_one_nat: nat ).

thf(sy_c_Groups_Oone__class_Oone_001t__Real__Oreal,type,
    one_one_real: real ).

thf(sy_c_Groups_Otimes__class_Otimes_001t__Int__Oint,type,
    times_times_int: int > int > int ).

thf(sy_c_Groups_Otimes__class_Otimes_001t__Nat__Onat,type,
    times_times_nat: nat > nat > nat ).

thf(sy_c_Groups_Otimes__class_Otimes_001t__Real__Oreal,type,
    times_times_real: real > real > real ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Int__Oint,type,
    zero_zero_int: int ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Nat__Onat,type,
    zero_zero_nat: nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Real__Oreal,type,
    zero_zero_real: real ).

thf(sy_c_Int_Oring__1__class_Oof__int_001t__Int__Oint,type,
    ring_1_of_int_int: int > int ).

thf(sy_c_Int_Oring__1__class_Oof__int_001t__Real__Oreal,type,
    ring_1_of_int_real: int > real ).

thf(sy_c_Liouville__Numbers__Mirabelle__onittbjwdi_Oliouville,type,
    liouvi1159869758uville: real > ( nat > int ) > ( nat > int ) > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Int__Oint,type,
    ord_less_int: int > int > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Nat__Onat,type,
    ord_less_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Real__Oreal,type,
    ord_less_real: real > real > $o ).

thf(sy_c_Polynomial_Oalgebraic_001t__Real__Oreal,type,
    algebraic_real: real > $o ).

thf(sy_c_Power_Opower__class_Opower_001t__Int__Oint,type,
    power_power_int: int > nat > int ).

thf(sy_c_Power_Opower__class_Opower_001t__Nat__Onat,type,
    power_power_nat: nat > nat > nat ).

thf(sy_c_Power_Opower__class_Opower_001t__Real__Oreal,type,
    power_power_real: real > nat > real ).

thf(sy_c_Rat_Ofield__char__0__class_ORats_001t__Real__Oreal,type,
    field_1537545994s_real: set_real ).

thf(sy_c_Rings_Odivide__class_Odivide_001t__Int__Oint,type,
    divide_divide_int: int > int > int ).

thf(sy_c_Rings_Odivide__class_Odivide_001t__Nat__Onat,type,
    divide_divide_nat: nat > nat > nat ).

thf(sy_c_Rings_Odivide__class_Odivide_001t__Real__Oreal,type,
    divide_divide_real: real > real > real ).

thf(sy_c_Set_OCollect_001t__Real__Oreal,type,
    collect_real: ( real > $o ) > set_real ).

thf(sy_c_member_001t__Real__Oreal,type,
    member_real: real > set_real > $o ).

thf(sy_v_c____,type,
    c: real ).

thf(sy_v_m____,type,
    m: nat ).

thf(sy_v_n____,type,
    n: nat ).

thf(sy_v_p,type,
    p: nat > int ).

thf(sy_v_q,type,
    q: nat > int ).

thf(sy_v_r____,type,
    r: nat ).

thf(sy_v_x,type,
    x: real ).

% Relevant facts (349)
thf(fact_0__092_060open_062algebraic_Ax_092_060close_062,axiom,
    algebraic_real @ x ).

% \<open>algebraic x\<close>
thf(fact_1_liouville__axioms,axiom,
    liouvi1159869758uville @ x @ p @ q ).

% liouville_axioms
thf(fact_2_denom__gt__1,axiom,
    ! [N: nat] : ( ord_less_int @ one_one_int @ ( q @ N ) ) ).

% denom_gt_1
thf(fact_3_cn_I1_J,axiom,
    ord_less_real @ zero_zero_real @ c ).

% cn(1)
thf(fact_4_irrational,axiom,
    ~ ( member_real @ x @ field_1537545994s_real ) ).

% irrational
thf(fact_5__092_060open_0621_A_060_Aq_Am_092_060close_062,axiom,
    ord_less_int @ one_one_int @ ( q @ m ) ).

% \<open>1 < q m\<close>
thf(fact_6_liouville_Odenom__gt__1,axiom,
    ! [X: real,P: nat > int,Q: nat > int,N: nat] :
      ( ( liouvi1159869758uville @ X @ P @ Q )
     => ( ord_less_int @ one_one_int @ ( Q @ N ) ) ) ).

% liouville.denom_gt_1
thf(fact_7_liouville_Oirrational,axiom,
    ! [X: real,P: nat > int,Q: nat > int] :
      ( ( liouvi1159869758uville @ X @ P @ Q )
     => ~ ( member_real @ X @ field_1537545994s_real ) ) ).

% liouville.irrational
thf(fact_8__092_060open_062_092_060bar_062x_A_N_Areal__of__int_A_Ip_Am_J_A_P_Areal__of__int_A_Iq_Am_J_092_060bar_062_A_060_Ac_A_P_Areal__of__int_A_Iq_Am_J_A_094_An_092_060close_062,axiom,
    ord_less_real @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ ( p @ m ) ) @ ( ring_1_of_int_real @ ( q @ m ) ) ) ) ) @ ( divide_divide_real @ c @ ( power_power_real @ ( ring_1_of_int_real @ ( q @ m ) ) @ n ) ) ).

% \<open>\<bar>x - real_of_int (p m) / real_of_int (q m)\<bar> < c / real_of_int (q m) ^ n\<close>
thf(fact_9__092_060open_0620_A_060_Aq_Am_A_092_060Longrightarrow_062_Ac_A_P_Areal__of__int_A_Iq_Am_J_A_094_An_A_060_A_092_060bar_062x_A_N_Areal__of__int_A_Ip_Am_J_A_P_Areal__of__int_A_Iq_Am_J_092_060bar_062_092_060close_062,axiom,
    ( ( ord_less_int @ zero_zero_int @ ( q @ m ) )
   => ( ord_less_real @ ( divide_divide_real @ c @ ( power_power_real @ ( ring_1_of_int_real @ ( q @ m ) ) @ n ) ) @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ ( p @ m ) ) @ ( ring_1_of_int_real @ ( q @ m ) ) ) ) ) ) ) ).

% \<open>0 < q m \<Longrightarrow> c / real_of_int (q m) ^ n < \<bar>x - real_of_int (p m) / real_of_int (q m)\<bar>\<close>
thf(fact_10_approx__int__pos,axiom,
    ! [N: nat] : ( ord_less_real @ zero_zero_real @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ ( p @ N ) ) @ ( ring_1_of_int_real @ ( q @ N ) ) ) ) ) ) ).

% approx_int_pos
thf(fact_11_not__gr__zero,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr_zero
thf(fact_12_of__int__1__less__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_int @ one_one_int @ ( ring_1_of_int_int @ Z ) )
      = ( ord_less_int @ one_one_int @ Z ) ) ).

% of_int_1_less_iff
thf(fact_13_of__int__1__less__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_real @ one_one_real @ ( ring_1_of_int_real @ Z ) )
      = ( ord_less_int @ one_one_int @ Z ) ) ).

% of_int_1_less_iff
thf(fact_14_of__int__less__1__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_int @ ( ring_1_of_int_int @ Z ) @ one_one_int )
      = ( ord_less_int @ Z @ one_one_int ) ) ).

% of_int_less_1_iff
thf(fact_15_of__int__less__1__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_real @ ( ring_1_of_int_real @ Z ) @ one_one_real )
      = ( ord_less_int @ Z @ one_one_int ) ) ).

% of_int_less_1_iff
thf(fact_16_less__numeral__extra_I1_J,axiom,
    ord_less_int @ zero_zero_int @ one_one_int ).

% less_numeral_extra(1)
thf(fact_17_less__numeral__extra_I1_J,axiom,
    ord_less_real @ zero_zero_real @ one_one_real ).

% less_numeral_extra(1)
thf(fact_18_less__numeral__extra_I1_J,axiom,
    ord_less_nat @ zero_zero_nat @ one_one_nat ).

% less_numeral_extra(1)
thf(fact_19_zero__less__one,axiom,
    ord_less_int @ zero_zero_int @ one_one_int ).

% zero_less_one
thf(fact_20_zero__less__one,axiom,
    ord_less_real @ zero_zero_real @ one_one_real ).

% zero_less_one
thf(fact_21_zero__less__one,axiom,
    ord_less_nat @ zero_zero_nat @ one_one_nat ).

% zero_less_one
thf(fact_22_not__one__less__zero,axiom,
    ~ ( ord_less_int @ one_one_int @ zero_zero_int ) ).

% not_one_less_zero
thf(fact_23_not__one__less__zero,axiom,
    ~ ( ord_less_real @ one_one_real @ zero_zero_real ) ).

% not_one_less_zero
thf(fact_24_not__one__less__zero,axiom,
    ~ ( ord_less_nat @ one_one_nat @ zero_zero_nat ) ).

% not_one_less_zero
thf(fact_25_abs__idempotent,axiom,
    ! [A: real] :
      ( ( abs_abs_real @ ( abs_abs_real @ A ) )
      = ( abs_abs_real @ A ) ) ).

% abs_idempotent
thf(fact_26_abs__idempotent,axiom,
    ! [A: int] :
      ( ( abs_abs_int @ ( abs_abs_int @ A ) )
      = ( abs_abs_int @ A ) ) ).

% abs_idempotent
thf(fact_27_abs__abs,axiom,
    ! [A: real] :
      ( ( abs_abs_real @ ( abs_abs_real @ A ) )
      = ( abs_abs_real @ A ) ) ).

% abs_abs
thf(fact_28_abs__abs,axiom,
    ! [A: int] :
      ( ( abs_abs_int @ ( abs_abs_int @ A ) )
      = ( abs_abs_int @ A ) ) ).

% abs_abs
thf(fact_29_of__int__eq__iff,axiom,
    ! [W: int,Z: int] :
      ( ( ( ring_1_of_int_real @ W )
        = ( ring_1_of_int_real @ Z ) )
      = ( W = Z ) ) ).

% of_int_eq_iff
thf(fact_30_cancel__comm__monoid__add__class_Odiff__cancel,axiom,
    ! [A: real] :
      ( ( minus_minus_real @ A @ A )
      = zero_zero_real ) ).

% cancel_comm_monoid_add_class.diff_cancel
thf(fact_31_cancel__comm__monoid__add__class_Odiff__cancel,axiom,
    ! [A: int] :
      ( ( minus_minus_int @ A @ A )
      = zero_zero_int ) ).

% cancel_comm_monoid_add_class.diff_cancel
thf(fact_32_cancel__comm__monoid__add__class_Odiff__cancel,axiom,
    ! [A: nat] :
      ( ( minus_minus_nat @ A @ A )
      = zero_zero_nat ) ).

% cancel_comm_monoid_add_class.diff_cancel
thf(fact_33_diff__zero,axiom,
    ! [A: real] :
      ( ( minus_minus_real @ A @ zero_zero_real )
      = A ) ).

% diff_zero
thf(fact_34_diff__zero,axiom,
    ! [A: int] :
      ( ( minus_minus_int @ A @ zero_zero_int )
      = A ) ).

% diff_zero
thf(fact_35_diff__zero,axiom,
    ! [A: nat] :
      ( ( minus_minus_nat @ A @ zero_zero_nat )
      = A ) ).

% diff_zero
thf(fact_36_zero__diff,axiom,
    ! [A: nat] :
      ( ( minus_minus_nat @ zero_zero_nat @ A )
      = zero_zero_nat ) ).

% zero_diff
thf(fact_37_diff__0__right,axiom,
    ! [A: real] :
      ( ( minus_minus_real @ A @ zero_zero_real )
      = A ) ).

% diff_0_right
thf(fact_38_diff__0__right,axiom,
    ! [A: int] :
      ( ( minus_minus_int @ A @ zero_zero_int )
      = A ) ).

% diff_0_right
thf(fact_39_diff__self,axiom,
    ! [A: real] :
      ( ( minus_minus_real @ A @ A )
      = zero_zero_real ) ).

% diff_self
thf(fact_40_diff__self,axiom,
    ! [A: int] :
      ( ( minus_minus_int @ A @ A )
      = zero_zero_int ) ).

% diff_self
thf(fact_41_div__by__0,axiom,
    ! [A: real] :
      ( ( divide_divide_real @ A @ zero_zero_real )
      = zero_zero_real ) ).

% div_by_0
thf(fact_42_div__by__0,axiom,
    ! [A: nat] :
      ( ( divide_divide_nat @ A @ zero_zero_nat )
      = zero_zero_nat ) ).

% div_by_0
thf(fact_43_div__by__0,axiom,
    ! [A: int] :
      ( ( divide_divide_int @ A @ zero_zero_int )
      = zero_zero_int ) ).

% div_by_0
thf(fact_44_div__0,axiom,
    ! [A: real] :
      ( ( divide_divide_real @ zero_zero_real @ A )
      = zero_zero_real ) ).

% div_0
thf(fact_45_div__0,axiom,
    ! [A: nat] :
      ( ( divide_divide_nat @ zero_zero_nat @ A )
      = zero_zero_nat ) ).

% div_0
thf(fact_46_div__0,axiom,
    ! [A: int] :
      ( ( divide_divide_int @ zero_zero_int @ A )
      = zero_zero_int ) ).

% div_0
thf(fact_47_div__by__1,axiom,
    ! [A: real] :
      ( ( divide_divide_real @ A @ one_one_real )
      = A ) ).

% div_by_1
thf(fact_48_div__by__1,axiom,
    ! [A: nat] :
      ( ( divide_divide_nat @ A @ one_one_nat )
      = A ) ).

% div_by_1
thf(fact_49_div__by__1,axiom,
    ! [A: int] :
      ( ( divide_divide_int @ A @ one_one_int )
      = A ) ).

% div_by_1
thf(fact_50_abs__zero,axiom,
    ( ( abs_abs_real @ zero_zero_real )
    = zero_zero_real ) ).

% abs_zero
thf(fact_51_abs__zero,axiom,
    ( ( abs_abs_int @ zero_zero_int )
    = zero_zero_int ) ).

% abs_zero
thf(fact_52_abs__eq__0,axiom,
    ! [A: real] :
      ( ( ( abs_abs_real @ A )
        = zero_zero_real )
      = ( A = zero_zero_real ) ) ).

% abs_eq_0
thf(fact_53_abs__eq__0,axiom,
    ! [A: int] :
      ( ( ( abs_abs_int @ A )
        = zero_zero_int )
      = ( A = zero_zero_int ) ) ).

% abs_eq_0
thf(fact_54_abs__0__eq,axiom,
    ! [A: real] :
      ( ( zero_zero_real
        = ( abs_abs_real @ A ) )
      = ( A = zero_zero_real ) ) ).

% abs_0_eq
thf(fact_55_abs__0__eq,axiom,
    ! [A: int] :
      ( ( zero_zero_int
        = ( abs_abs_int @ A ) )
      = ( A = zero_zero_int ) ) ).

% abs_0_eq
thf(fact_56_abs__0,axiom,
    ( ( abs_abs_real @ zero_zero_real )
    = zero_zero_real ) ).

% abs_0
thf(fact_57_abs__0,axiom,
    ( ( abs_abs_int @ zero_zero_int )
    = zero_zero_int ) ).

% abs_0
thf(fact_58_abs__1,axiom,
    ( ( abs_abs_int @ one_one_int )
    = one_one_int ) ).

% abs_1
thf(fact_59_abs__1,axiom,
    ( ( abs_abs_real @ one_one_real )
    = one_one_real ) ).

% abs_1
thf(fact_60_of__int__diff,axiom,
    ! [W: int,Z: int] :
      ( ( ring_1_of_int_real @ ( minus_minus_int @ W @ Z ) )
      = ( minus_minus_real @ ( ring_1_of_int_real @ W ) @ ( ring_1_of_int_real @ Z ) ) ) ).

% of_int_diff
thf(fact_61_of__int__diff,axiom,
    ! [W: int,Z: int] :
      ( ( ring_1_of_int_int @ ( minus_minus_int @ W @ Z ) )
      = ( minus_minus_int @ ( ring_1_of_int_int @ W ) @ ( ring_1_of_int_int @ Z ) ) ) ).

% of_int_diff
thf(fact_62_of__int__power__eq__of__int__cancel__iff,axiom,
    ! [X: int,B: int,W: nat] :
      ( ( ( ring_1_of_int_real @ X )
        = ( power_power_real @ ( ring_1_of_int_real @ B ) @ W ) )
      = ( X
        = ( power_power_int @ B @ W ) ) ) ).

% of_int_power_eq_of_int_cancel_iff
thf(fact_63_of__int__eq__of__int__power__cancel__iff,axiom,
    ! [B: int,W: nat,X: int] :
      ( ( ( power_power_real @ ( ring_1_of_int_real @ B ) @ W )
        = ( ring_1_of_int_real @ X ) )
      = ( ( power_power_int @ B @ W )
        = X ) ) ).

% of_int_eq_of_int_power_cancel_iff
thf(fact_64_of__int__power,axiom,
    ! [Z: int,N: nat] :
      ( ( ring_1_of_int_real @ ( power_power_int @ Z @ N ) )
      = ( power_power_real @ ( ring_1_of_int_real @ Z ) @ N ) ) ).

% of_int_power
thf(fact_65_of__int__abs,axiom,
    ! [X: int] :
      ( ( ring_1_of_int_int @ ( abs_abs_int @ X ) )
      = ( abs_abs_int @ ( ring_1_of_int_int @ X ) ) ) ).

% of_int_abs
thf(fact_66_of__int__abs,axiom,
    ! [X: int] :
      ( ( ring_1_of_int_real @ ( abs_abs_int @ X ) )
      = ( abs_abs_real @ ( ring_1_of_int_real @ X ) ) ) ).

% of_int_abs
thf(fact_67__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062c_An_O_A_092_060lbrakk_0620_A_060_Ac_059_A_092_060And_062p_Aq_O_A0_A_060_Aq_A_092_060Longrightarrow_062_Ac_A_P_Areal__of__int_Aq_A_094_An_A_060_A_092_060bar_062x_A_N_Areal__of__int_Ap_A_P_Areal__of__int_Aq_092_060bar_062_092_060rbrakk_062_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [C: real] :
        ( ( ord_less_real @ zero_zero_real @ C )
       => ! [N2: nat] :
            ~ ! [P2: int,Q2: int] :
                ( ( ord_less_int @ zero_zero_int @ Q2 )
               => ( ord_less_real @ ( divide_divide_real @ C @ ( power_power_real @ ( ring_1_of_int_real @ Q2 ) @ N2 ) ) @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ P2 ) @ ( ring_1_of_int_real @ Q2 ) ) ) ) ) ) ) ).

% \<open>\<And>thesis. (\<And>c n. \<lbrakk>0 < c; \<And>p q. 0 < q \<Longrightarrow> c / real_of_int q ^ n < \<bar>x - real_of_int p / real_of_int q\<bar>\<rbrakk> \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_68__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062c_An_O_A_092_060lbrakk_0620_A_060_Ac_059_A_092_060And_062p_Aq_O_A0_A_060_Aq_A_092_060Longrightarrow_062_Ac_A_P_Areal__of__int_Aq_A_094_An_A_060_A_092_060bar_062x_A_N_Areal__of__int_Ap_A_P_Areal__of__int_Aq_092_060bar_062_092_060rbrakk_062_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [C: real] :
        ( ( ord_less_real @ zero_zero_real @ C )
       => ! [N2: nat] :
            ~ ! [P2: int,Q2: int] :
                ( ( ord_less_int @ zero_zero_int @ Q2 )
               => ( ord_less_real @ ( divide_divide_real @ C @ ( power_power_real @ ( ring_1_of_int_real @ Q2 ) @ N2 ) ) @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ P2 ) @ ( ring_1_of_int_real @ Q2 ) ) ) ) ) ) ) ).

% \<open>\<And>thesis. (\<And>c n. \<lbrakk>0 < c; \<And>p q. 0 < q \<Longrightarrow> c / real_of_int q ^ n < \<bar>x - real_of_int p / real_of_int q\<bar>\<rbrakk> \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_69_diff__gt__0__iff__gt,axiom,
    ! [A: int,B: int] :
      ( ( ord_less_int @ zero_zero_int @ ( minus_minus_int @ A @ B ) )
      = ( ord_less_int @ B @ A ) ) ).

% diff_gt_0_iff_gt
thf(fact_70_diff__gt__0__iff__gt,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ zero_zero_real @ ( minus_minus_real @ A @ B ) )
      = ( ord_less_real @ B @ A ) ) ).

% diff_gt_0_iff_gt
thf(fact_71_diff__numeral__special_I9_J,axiom,
    ( ( minus_minus_real @ one_one_real @ one_one_real )
    = zero_zero_real ) ).

% diff_numeral_special(9)
thf(fact_72_diff__numeral__special_I9_J,axiom,
    ( ( minus_minus_int @ one_one_int @ one_one_int )
    = zero_zero_int ) ).

% diff_numeral_special(9)
thf(fact_73_div__self,axiom,
    ! [A: real] :
      ( ( A != zero_zero_real )
     => ( ( divide_divide_real @ A @ A )
        = one_one_real ) ) ).

% div_self
thf(fact_74_div__self,axiom,
    ! [A: nat] :
      ( ( A != zero_zero_nat )
     => ( ( divide_divide_nat @ A @ A )
        = one_one_nat ) ) ).

% div_self
thf(fact_75_div__self,axiom,
    ! [A: int] :
      ( ( A != zero_zero_int )
     => ( ( divide_divide_int @ A @ A )
        = one_one_int ) ) ).

% div_self
thf(fact_76_mem__Collect__eq,axiom,
    ! [A: real,P3: real > $o] :
      ( ( member_real @ A @ ( collect_real @ P3 ) )
      = ( P3 @ A ) ) ).

% mem_Collect_eq
thf(fact_77_Collect__mem__eq,axiom,
    ! [A2: set_real] :
      ( ( collect_real
        @ ^ [X2: real] : ( member_real @ X2 @ A2 ) )
      = A2 ) ).

% Collect_mem_eq
thf(fact_78_zero__less__abs__iff,axiom,
    ! [A: int] :
      ( ( ord_less_int @ zero_zero_int @ ( abs_abs_int @ A ) )
      = ( A != zero_zero_int ) ) ).

% zero_less_abs_iff
thf(fact_79_zero__less__abs__iff,axiom,
    ! [A: real] :
      ( ( ord_less_real @ zero_zero_real @ ( abs_abs_real @ A ) )
      = ( A != zero_zero_real ) ) ).

% zero_less_abs_iff
thf(fact_80_of__int__eq__0__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_int @ Z )
        = zero_zero_int )
      = ( Z = zero_zero_int ) ) ).

% of_int_eq_0_iff
thf(fact_81_of__int__eq__0__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_real @ Z )
        = zero_zero_real )
      = ( Z = zero_zero_int ) ) ).

% of_int_eq_0_iff
thf(fact_82_of__int__0__eq__iff,axiom,
    ! [Z: int] :
      ( ( zero_zero_int
        = ( ring_1_of_int_int @ Z ) )
      = ( Z = zero_zero_int ) ) ).

% of_int_0_eq_iff
thf(fact_83_of__int__0__eq__iff,axiom,
    ! [Z: int] :
      ( ( zero_zero_real
        = ( ring_1_of_int_real @ Z ) )
      = ( Z = zero_zero_int ) ) ).

% of_int_0_eq_iff
thf(fact_84_of__int__0,axiom,
    ( ( ring_1_of_int_int @ zero_zero_int )
    = zero_zero_int ) ).

% of_int_0
thf(fact_85_of__int__0,axiom,
    ( ( ring_1_of_int_real @ zero_zero_int )
    = zero_zero_real ) ).

% of_int_0
thf(fact_86_of__int__less__iff,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less_int @ ( ring_1_of_int_int @ W ) @ ( ring_1_of_int_int @ Z ) )
      = ( ord_less_int @ W @ Z ) ) ).

% of_int_less_iff
thf(fact_87_of__int__less__iff,axiom,
    ! [W: int,Z: int] :
      ( ( ord_less_real @ ( ring_1_of_int_real @ W ) @ ( ring_1_of_int_real @ Z ) )
      = ( ord_less_int @ W @ Z ) ) ).

% of_int_less_iff
thf(fact_88_of__int__eq__1__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_int @ Z )
        = one_one_int )
      = ( Z = one_one_int ) ) ).

% of_int_eq_1_iff
thf(fact_89_of__int__eq__1__iff,axiom,
    ! [Z: int] :
      ( ( ( ring_1_of_int_real @ Z )
        = one_one_real )
      = ( Z = one_one_int ) ) ).

% of_int_eq_1_iff
thf(fact_90_of__int__1,axiom,
    ( ( ring_1_of_int_int @ one_one_int )
    = one_one_int ) ).

% of_int_1
thf(fact_91_of__int__1,axiom,
    ( ( ring_1_of_int_real @ one_one_int )
    = one_one_real ) ).

% of_int_1
thf(fact_92_approx__int,axiom,
    ! [N: nat] : ( ord_less_real @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ ( p @ N ) ) @ ( ring_1_of_int_real @ ( q @ N ) ) ) ) ) @ ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( q @ N ) ) @ N ) ) ) ).

% approx_int
thf(fact_93__092_060open_062_092_060bar_062x_A_N_Areal__of__int_A_Ip_Am_J_A_P_Areal__of__int_A_Iq_Am_J_092_060bar_062_A_060_A1_A_P_Areal__of__int_A_Iq_Am_J_A_094_Am_092_060close_062,axiom,
    ord_less_real @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ ( p @ m ) ) @ ( ring_1_of_int_real @ ( q @ m ) ) ) ) ) @ ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( q @ m ) ) @ m ) ) ).

% \<open>\<bar>x - real_of_int (p m) / real_of_int (q m)\<bar> < 1 / real_of_int (q m) ^ m\<close>
thf(fact_94_cn_I2_J,axiom,
    ! [Q: int,P: int] :
      ( ( ord_less_int @ zero_zero_int @ Q )
     => ( ord_less_real @ ( divide_divide_real @ c @ ( power_power_real @ ( ring_1_of_int_real @ Q ) @ n ) ) @ ( abs_abs_real @ ( minus_minus_real @ x @ ( divide_divide_real @ ( ring_1_of_int_real @ P ) @ ( ring_1_of_int_real @ Q ) ) ) ) ) ) ).

% cn(2)
thf(fact_95_of__int__power__less__of__int__cancel__iff,axiom,
    ! [X: int,B: int,W: nat] :
      ( ( ord_less_int @ ( ring_1_of_int_int @ X ) @ ( power_power_int @ ( ring_1_of_int_int @ B ) @ W ) )
      = ( ord_less_int @ X @ ( power_power_int @ B @ W ) ) ) ).

% of_int_power_less_of_int_cancel_iff
thf(fact_96_of__int__power__less__of__int__cancel__iff,axiom,
    ! [X: int,B: int,W: nat] :
      ( ( ord_less_real @ ( ring_1_of_int_real @ X ) @ ( power_power_real @ ( ring_1_of_int_real @ B ) @ W ) )
      = ( ord_less_int @ X @ ( power_power_int @ B @ W ) ) ) ).

% of_int_power_less_of_int_cancel_iff
thf(fact_97_of__int__less__of__int__power__cancel__iff,axiom,
    ! [B: int,W: nat,X: int] :
      ( ( ord_less_int @ ( power_power_int @ ( ring_1_of_int_int @ B ) @ W ) @ ( ring_1_of_int_int @ X ) )
      = ( ord_less_int @ ( power_power_int @ B @ W ) @ X ) ) ).

% of_int_less_of_int_power_cancel_iff
thf(fact_98_of__int__less__of__int__power__cancel__iff,axiom,
    ! [B: int,W: nat,X: int] :
      ( ( ord_less_real @ ( power_power_real @ ( ring_1_of_int_real @ B ) @ W ) @ ( ring_1_of_int_real @ X ) )
      = ( ord_less_int @ ( power_power_int @ B @ W ) @ X ) ) ).

% of_int_less_of_int_power_cancel_iff
thf(fact_99_of__int__less__0__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_int @ ( ring_1_of_int_int @ Z ) @ zero_zero_int )
      = ( ord_less_int @ Z @ zero_zero_int ) ) ).

% of_int_less_0_iff
thf(fact_100_of__int__less__0__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_real @ ( ring_1_of_int_real @ Z ) @ zero_zero_real )
      = ( ord_less_int @ Z @ zero_zero_int ) ) ).

% of_int_less_0_iff
thf(fact_101_of__int__0__less__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_int @ zero_zero_int @ ( ring_1_of_int_int @ Z ) )
      = ( ord_less_int @ zero_zero_int @ Z ) ) ).

% of_int_0_less_iff
thf(fact_102_of__int__0__less__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_real @ zero_zero_real @ ( ring_1_of_int_real @ Z ) )
      = ( ord_less_int @ zero_zero_int @ Z ) ) ).

% of_int_0_less_iff
thf(fact_103_abs__minus__commute,axiom,
    ! [A: real,B: real] :
      ( ( abs_abs_real @ ( minus_minus_real @ A @ B ) )
      = ( abs_abs_real @ ( minus_minus_real @ B @ A ) ) ) ).

% abs_minus_commute
thf(fact_104_abs__minus__commute,axiom,
    ! [A: int,B: int] :
      ( ( abs_abs_int @ ( minus_minus_int @ A @ B ) )
      = ( abs_abs_int @ ( minus_minus_int @ B @ A ) ) ) ).

% abs_minus_commute
thf(fact_105_cancel__ab__semigroup__add__class_Odiff__right__commute,axiom,
    ! [A: real,C2: real,B: real] :
      ( ( minus_minus_real @ ( minus_minus_real @ A @ C2 ) @ B )
      = ( minus_minus_real @ ( minus_minus_real @ A @ B ) @ C2 ) ) ).

% cancel_ab_semigroup_add_class.diff_right_commute
thf(fact_106_cancel__ab__semigroup__add__class_Odiff__right__commute,axiom,
    ! [A: int,C2: int,B: int] :
      ( ( minus_minus_int @ ( minus_minus_int @ A @ C2 ) @ B )
      = ( minus_minus_int @ ( minus_minus_int @ A @ B ) @ C2 ) ) ).

% cancel_ab_semigroup_add_class.diff_right_commute
thf(fact_107_cancel__ab__semigroup__add__class_Odiff__right__commute,axiom,
    ! [A: nat,C2: nat,B: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ A @ C2 ) @ B )
      = ( minus_minus_nat @ ( minus_minus_nat @ A @ B ) @ C2 ) ) ).

% cancel_ab_semigroup_add_class.diff_right_commute
thf(fact_108_diff__eq__diff__eq,axiom,
    ! [A: real,B: real,C2: real,D: real] :
      ( ( ( minus_minus_real @ A @ B )
        = ( minus_minus_real @ C2 @ D ) )
     => ( ( A = B )
        = ( C2 = D ) ) ) ).

% diff_eq_diff_eq
thf(fact_109_diff__eq__diff__eq,axiom,
    ! [A: int,B: int,C2: int,D: int] :
      ( ( ( minus_minus_int @ A @ B )
        = ( minus_minus_int @ C2 @ D ) )
     => ( ( A = B )
        = ( C2 = D ) ) ) ).

% diff_eq_diff_eq
thf(fact_110_liouville_Oapprox__int,axiom,
    ! [X: real,P: nat > int,Q: nat > int,N: nat] :
      ( ( liouvi1159869758uville @ X @ P @ Q )
     => ( ord_less_real @ ( abs_abs_real @ ( minus_minus_real @ X @ ( divide_divide_real @ ( ring_1_of_int_real @ ( P @ N ) ) @ ( ring_1_of_int_real @ ( Q @ N ) ) ) ) ) @ ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( Q @ N ) ) @ N ) ) ) ) ).

% liouville.approx_int
thf(fact_111_abs__eq__0__iff,axiom,
    ! [A: real] :
      ( ( ( abs_abs_real @ A )
        = zero_zero_real )
      = ( A = zero_zero_real ) ) ).

% abs_eq_0_iff
thf(fact_112_abs__eq__0__iff,axiom,
    ! [A: int] :
      ( ( ( abs_abs_int @ A )
        = zero_zero_int )
      = ( A = zero_zero_int ) ) ).

% abs_eq_0_iff
thf(fact_113_abs__one,axiom,
    ( ( abs_abs_int @ one_one_int )
    = one_one_int ) ).

% abs_one
thf(fact_114_abs__one,axiom,
    ( ( abs_abs_real @ one_one_real )
    = one_one_real ) ).

% abs_one
thf(fact_115_eq__iff__diff__eq__0,axiom,
    ( ( ^ [Y: real,Z2: real] : ( Y = Z2 ) )
    = ( ^ [A3: real,B2: real] :
          ( ( minus_minus_real @ A3 @ B2 )
          = zero_zero_real ) ) ) ).

% eq_iff_diff_eq_0
thf(fact_116_eq__iff__diff__eq__0,axiom,
    ( ( ^ [Y: int,Z2: int] : ( Y = Z2 ) )
    = ( ^ [A3: int,B2: int] :
          ( ( minus_minus_int @ A3 @ B2 )
          = zero_zero_int ) ) ) ).

% eq_iff_diff_eq_0
thf(fact_117_diff__strict__right__mono,axiom,
    ! [A: int,B: int,C2: int] :
      ( ( ord_less_int @ A @ B )
     => ( ord_less_int @ ( minus_minus_int @ A @ C2 ) @ ( minus_minus_int @ B @ C2 ) ) ) ).

% diff_strict_right_mono
thf(fact_118_diff__strict__right__mono,axiom,
    ! [A: real,B: real,C2: real] :
      ( ( ord_less_real @ A @ B )
     => ( ord_less_real @ ( minus_minus_real @ A @ C2 ) @ ( minus_minus_real @ B @ C2 ) ) ) ).

% diff_strict_right_mono
thf(fact_119_diff__strict__left__mono,axiom,
    ! [B: int,A: int,C2: int] :
      ( ( ord_less_int @ B @ A )
     => ( ord_less_int @ ( minus_minus_int @ C2 @ A ) @ ( minus_minus_int @ C2 @ B ) ) ) ).

% diff_strict_left_mono
thf(fact_120_diff__strict__left__mono,axiom,
    ! [B: real,A: real,C2: real] :
      ( ( ord_less_real @ B @ A )
     => ( ord_less_real @ ( minus_minus_real @ C2 @ A ) @ ( minus_minus_real @ C2 @ B ) ) ) ).

% diff_strict_left_mono
thf(fact_121_diff__eq__diff__less,axiom,
    ! [A: int,B: int,C2: int,D: int] :
      ( ( ( minus_minus_int @ A @ B )
        = ( minus_minus_int @ C2 @ D ) )
     => ( ( ord_less_int @ A @ B )
        = ( ord_less_int @ C2 @ D ) ) ) ).

% diff_eq_diff_less
thf(fact_122_diff__eq__diff__less,axiom,
    ! [A: real,B: real,C2: real,D: real] :
      ( ( ( minus_minus_real @ A @ B )
        = ( minus_minus_real @ C2 @ D ) )
     => ( ( ord_less_real @ A @ B )
        = ( ord_less_real @ C2 @ D ) ) ) ).

% diff_eq_diff_less
thf(fact_123_diff__strict__mono,axiom,
    ! [A: int,B: int,D: int,C2: int] :
      ( ( ord_less_int @ A @ B )
     => ( ( ord_less_int @ D @ C2 )
       => ( ord_less_int @ ( minus_minus_int @ A @ C2 ) @ ( minus_minus_int @ B @ D ) ) ) ) ).

% diff_strict_mono
thf(fact_124_diff__strict__mono,axiom,
    ! [A: real,B: real,D: real,C2: real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_real @ D @ C2 )
       => ( ord_less_real @ ( minus_minus_real @ A @ C2 ) @ ( minus_minus_real @ B @ D ) ) ) ) ).

% diff_strict_mono
thf(fact_125_of__int__lessD,axiom,
    ! [N: int,X: int] :
      ( ( ord_less_int @ ( abs_abs_int @ ( ring_1_of_int_int @ N ) ) @ X )
     => ( ( N = zero_zero_int )
        | ( ord_less_int @ one_one_int @ X ) ) ) ).

% of_int_lessD
thf(fact_126_of__int__lessD,axiom,
    ! [N: int,X: real] :
      ( ( ord_less_real @ ( abs_abs_real @ ( ring_1_of_int_real @ N ) ) @ X )
     => ( ( N = zero_zero_int )
        | ( ord_less_real @ one_one_real @ X ) ) ) ).

% of_int_lessD
thf(fact_127_less__int__code_I1_J,axiom,
    ~ ( ord_less_int @ zero_zero_int @ zero_zero_int ) ).

% less_int_code(1)
thf(fact_128_liouville_Ointro,axiom,
    ! [X: real,P: nat > int,Q: nat > int] :
      ( ! [N2: nat] : ( ord_less_real @ zero_zero_real @ ( abs_abs_real @ ( minus_minus_real @ X @ ( divide_divide_real @ ( ring_1_of_int_real @ ( P @ N2 ) ) @ ( ring_1_of_int_real @ ( Q @ N2 ) ) ) ) ) )
     => ( ! [N2: nat] : ( ord_less_int @ one_one_int @ ( Q @ N2 ) )
       => ( ! [N2: nat] : ( ord_less_real @ ( abs_abs_real @ ( minus_minus_real @ X @ ( divide_divide_real @ ( ring_1_of_int_real @ ( P @ N2 ) ) @ ( ring_1_of_int_real @ ( Q @ N2 ) ) ) ) ) @ ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( Q @ N2 ) ) @ N2 ) ) )
         => ( liouvi1159869758uville @ X @ P @ Q ) ) ) ) ).

% liouville.intro
thf(fact_129_liouville__def,axiom,
    ( liouvi1159869758uville
    = ( ^ [X2: real,P4: nat > int,Q3: nat > int] :
          ( ! [N3: nat] : ( ord_less_real @ zero_zero_real @ ( abs_abs_real @ ( minus_minus_real @ X2 @ ( divide_divide_real @ ( ring_1_of_int_real @ ( P4 @ N3 ) ) @ ( ring_1_of_int_real @ ( Q3 @ N3 ) ) ) ) ) )
          & ! [N3: nat] : ( ord_less_int @ one_one_int @ ( Q3 @ N3 ) )
          & ! [N3: nat] : ( ord_less_real @ ( abs_abs_real @ ( minus_minus_real @ X2 @ ( divide_divide_real @ ( ring_1_of_int_real @ ( P4 @ N3 ) ) @ ( ring_1_of_int_real @ ( Q3 @ N3 ) ) ) ) ) @ ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( Q3 @ N3 ) ) @ N3 ) ) ) ) ) ) ).

% liouville_def
thf(fact_130_zero__reorient,axiom,
    ! [X: real] :
      ( ( zero_zero_real = X )
      = ( X = zero_zero_real ) ) ).

% zero_reorient
thf(fact_131_zero__reorient,axiom,
    ! [X: int] :
      ( ( zero_zero_int = X )
      = ( X = zero_zero_int ) ) ).

% zero_reorient
thf(fact_132_zero__reorient,axiom,
    ! [X: nat] :
      ( ( zero_zero_nat = X )
      = ( X = zero_zero_nat ) ) ).

% zero_reorient
thf(fact_133_linorder__neqE__linordered__idom,axiom,
    ! [X: int,Y2: int] :
      ( ( X != Y2 )
     => ( ~ ( ord_less_int @ X @ Y2 )
       => ( ord_less_int @ Y2 @ X ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_134_linorder__neqE__linordered__idom,axiom,
    ! [X: real,Y2: real] :
      ( ( X != Y2 )
     => ( ~ ( ord_less_real @ X @ Y2 )
       => ( ord_less_real @ Y2 @ X ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_135_abs__not__less__zero,axiom,
    ! [A: int] :
      ~ ( ord_less_int @ ( abs_abs_int @ A ) @ zero_zero_int ) ).

% abs_not_less_zero
thf(fact_136_abs__not__less__zero,axiom,
    ! [A: real] :
      ~ ( ord_less_real @ ( abs_abs_real @ A ) @ zero_zero_real ) ).

% abs_not_less_zero
thf(fact_137_abs__of__pos,axiom,
    ! [A: int] :
      ( ( ord_less_int @ zero_zero_int @ A )
     => ( ( abs_abs_int @ A )
        = A ) ) ).

% abs_of_pos
thf(fact_138_abs__of__pos,axiom,
    ! [A: real] :
      ( ( ord_less_real @ zero_zero_real @ A )
     => ( ( abs_abs_real @ A )
        = A ) ) ).

% abs_of_pos
thf(fact_139_one__reorient,axiom,
    ! [X: int] :
      ( ( one_one_int = X )
      = ( X = one_one_int ) ) ).

% one_reorient
thf(fact_140_one__reorient,axiom,
    ! [X: real] :
      ( ( one_one_real = X )
      = ( X = one_one_real ) ) ).

% one_reorient
thf(fact_141_one__reorient,axiom,
    ! [X: nat] :
      ( ( one_one_nat = X )
      = ( X = one_one_nat ) ) ).

% one_reorient
thf(fact_142_less__iff__diff__less__0,axiom,
    ( ord_less_int
    = ( ^ [A3: int,B2: int] : ( ord_less_int @ ( minus_minus_int @ A3 @ B2 ) @ zero_zero_int ) ) ) ).

% less_iff_diff_less_0
thf(fact_143_less__iff__diff__less__0,axiom,
    ( ord_less_real
    = ( ^ [A3: real,B2: real] : ( ord_less_real @ ( minus_minus_real @ A3 @ B2 ) @ zero_zero_real ) ) ) ).

% less_iff_diff_less_0
thf(fact_144_liouville_Oapprox__int__pos,axiom,
    ! [X: real,P: nat > int,Q: nat > int,N: nat] :
      ( ( liouvi1159869758uville @ X @ P @ Q )
     => ( ord_less_real @ zero_zero_real @ ( abs_abs_real @ ( minus_minus_real @ X @ ( divide_divide_real @ ( ring_1_of_int_real @ ( P @ N ) ) @ ( ring_1_of_int_real @ ( Q @ N ) ) ) ) ) ) ) ).

% liouville.approx_int_pos
thf(fact_145_liouville__irrational__algebraic,axiom,
    ! [X: real] :
      ( ~ ( member_real @ X @ field_1537545994s_real )
     => ( ( algebraic_real @ X )
       => ~ ! [C: real] :
              ( ( ord_less_real @ zero_zero_real @ C )
             => ! [N2: nat] :
                  ~ ! [P2: int,Q2: int] :
                      ( ( ord_less_int @ zero_zero_int @ Q2 )
                     => ( ord_less_real @ ( divide_divide_real @ C @ ( power_power_real @ ( ring_1_of_int_real @ Q2 ) @ N2 ) ) @ ( abs_abs_real @ ( minus_minus_real @ X @ ( divide_divide_real @ ( ring_1_of_int_real @ P2 ) @ ( ring_1_of_int_real @ Q2 ) ) ) ) ) ) ) ) ) ).

% liouville_irrational_algebraic
thf(fact_146_of__int__pos,axiom,
    ! [Z: int] :
      ( ( ord_less_int @ zero_zero_int @ Z )
     => ( ord_less_int @ zero_zero_int @ ( ring_1_of_int_int @ Z ) ) ) ).

% of_int_pos
thf(fact_147_of__int__pos,axiom,
    ! [Z: int] :
      ( ( ord_less_int @ zero_zero_int @ Z )
     => ( ord_less_real @ zero_zero_real @ ( ring_1_of_int_real @ Z ) ) ) ).

% of_int_pos
thf(fact_148_zero__less__iff__neq__zero,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
      = ( N != zero_zero_nat ) ) ).

% zero_less_iff_neq_zero
thf(fact_149_gr__implies__not__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not_zero
thf(fact_150_not__less__zero,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less_zero
thf(fact_151_gr__zeroI,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr_zeroI
thf(fact_152_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_int @ zero_zero_int @ zero_zero_int ) ).

% less_numeral_extra(3)
thf(fact_153_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_real @ zero_zero_real @ zero_zero_real ) ).

% less_numeral_extra(3)
thf(fact_154_less__numeral__extra_I3_J,axiom,
    ~ ( ord_less_nat @ zero_zero_nat @ zero_zero_nat ) ).

% less_numeral_extra(3)
thf(fact_155_zero__neq__one,axiom,
    zero_zero_real != one_one_real ).

% zero_neq_one
thf(fact_156_zero__neq__one,axiom,
    zero_zero_int != one_one_int ).

% zero_neq_one
thf(fact_157_zero__neq__one,axiom,
    zero_zero_nat != one_one_nat ).

% zero_neq_one
thf(fact_158_less__numeral__extra_I4_J,axiom,
    ~ ( ord_less_int @ one_one_int @ one_one_int ) ).

% less_numeral_extra(4)
thf(fact_159_less__numeral__extra_I4_J,axiom,
    ~ ( ord_less_real @ one_one_real @ one_one_real ) ).

% less_numeral_extra(4)
thf(fact_160_less__numeral__extra_I4_J,axiom,
    ~ ( ord_less_nat @ one_one_nat @ one_one_nat ) ).

% less_numeral_extra(4)
thf(fact_161_zero__less__power__abs__iff,axiom,
    ! [A: int,N: nat] :
      ( ( ord_less_int @ zero_zero_int @ ( power_power_int @ ( abs_abs_int @ A ) @ N ) )
      = ( ( A != zero_zero_int )
        | ( N = zero_zero_nat ) ) ) ).

% zero_less_power_abs_iff
thf(fact_162_zero__less__power__abs__iff,axiom,
    ! [A: real,N: nat] :
      ( ( ord_less_real @ zero_zero_real @ ( power_power_real @ ( abs_abs_real @ A ) @ N ) )
      = ( ( A != zero_zero_real )
        | ( N = zero_zero_nat ) ) ) ).

% zero_less_power_abs_iff
thf(fact_163_power__strict__decreasing__iff,axiom,
    ! [B: int,M: nat,N: nat] :
      ( ( ord_less_int @ zero_zero_int @ B )
     => ( ( ord_less_int @ B @ one_one_int )
       => ( ( ord_less_int @ ( power_power_int @ B @ M ) @ ( power_power_int @ B @ N ) )
          = ( ord_less_nat @ N @ M ) ) ) ) ).

% power_strict_decreasing_iff
thf(fact_164_power__strict__decreasing__iff,axiom,
    ! [B: real,M: nat,N: nat] :
      ( ( ord_less_real @ zero_zero_real @ B )
     => ( ( ord_less_real @ B @ one_one_real )
       => ( ( ord_less_real @ ( power_power_real @ B @ M ) @ ( power_power_real @ B @ N ) )
          = ( ord_less_nat @ N @ M ) ) ) ) ).

% power_strict_decreasing_iff
thf(fact_165_power__strict__decreasing__iff,axiom,
    ! [B: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ B )
     => ( ( ord_less_nat @ B @ one_one_nat )
       => ( ( ord_less_nat @ ( power_power_nat @ B @ M ) @ ( power_power_nat @ B @ N ) )
          = ( ord_less_nat @ N @ M ) ) ) ) ).

% power_strict_decreasing_iff
thf(fact_166_zero__less__divide__1__iff,axiom,
    ! [A: real] :
      ( ( ord_less_real @ zero_zero_real @ ( divide_divide_real @ one_one_real @ A ) )
      = ( ord_less_real @ zero_zero_real @ A ) ) ).

% zero_less_divide_1_iff
thf(fact_167_less__divide__eq__1__pos,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ zero_zero_real @ A )
     => ( ( ord_less_real @ one_one_real @ ( divide_divide_real @ B @ A ) )
        = ( ord_less_real @ A @ B ) ) ) ).

% less_divide_eq_1_pos
thf(fact_168_less__divide__eq__1__neg,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ A @ zero_zero_real )
     => ( ( ord_less_real @ one_one_real @ ( divide_divide_real @ B @ A ) )
        = ( ord_less_real @ B @ A ) ) ) ).

% less_divide_eq_1_neg
thf(fact_169_divide__less__eq__1__pos,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ zero_zero_real @ A )
     => ( ( ord_less_real @ ( divide_divide_real @ B @ A ) @ one_one_real )
        = ( ord_less_real @ B @ A ) ) ) ).

% divide_less_eq_1_pos
thf(fact_170_divide__less__eq__1__neg,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ A @ zero_zero_real )
     => ( ( ord_less_real @ ( divide_divide_real @ B @ A ) @ one_one_real )
        = ( ord_less_real @ A @ B ) ) ) ).

% divide_less_eq_1_neg
thf(fact_171_divide__less__0__1__iff,axiom,
    ! [A: real] :
      ( ( ord_less_real @ ( divide_divide_real @ one_one_real @ A ) @ zero_zero_real )
      = ( ord_less_real @ A @ zero_zero_real ) ) ).

% divide_less_0_1_iff
thf(fact_172_power__strict__increasing__iff,axiom,
    ! [B: int,X: nat,Y2: nat] :
      ( ( ord_less_int @ one_one_int @ B )
     => ( ( ord_less_int @ ( power_power_int @ B @ X ) @ ( power_power_int @ B @ Y2 ) )
        = ( ord_less_nat @ X @ Y2 ) ) ) ).

% power_strict_increasing_iff
thf(fact_173_power__strict__increasing__iff,axiom,
    ! [B: real,X: nat,Y2: nat] :
      ( ( ord_less_real @ one_one_real @ B )
     => ( ( ord_less_real @ ( power_power_real @ B @ X ) @ ( power_power_real @ B @ Y2 ) )
        = ( ord_less_nat @ X @ Y2 ) ) ) ).

% power_strict_increasing_iff
thf(fact_174_power__strict__increasing__iff,axiom,
    ! [B: nat,X: nat,Y2: nat] :
      ( ( ord_less_nat @ one_one_nat @ B )
     => ( ( ord_less_nat @ ( power_power_nat @ B @ X ) @ ( power_power_nat @ B @ Y2 ) )
        = ( ord_less_nat @ X @ Y2 ) ) ) ).

% power_strict_increasing_iff
thf(fact_175_power__inject__exp,axiom,
    ! [A: int,M: nat,N: nat] :
      ( ( ord_less_int @ one_one_int @ A )
     => ( ( ( power_power_int @ A @ M )
          = ( power_power_int @ A @ N ) )
        = ( M = N ) ) ) ).

% power_inject_exp
thf(fact_176_power__inject__exp,axiom,
    ! [A: real,M: nat,N: nat] :
      ( ( ord_less_real @ one_one_real @ A )
     => ( ( ( power_power_real @ A @ M )
          = ( power_power_real @ A @ N ) )
        = ( M = N ) ) ) ).

% power_inject_exp
thf(fact_177_power__inject__exp,axiom,
    ! [A: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ one_one_nat @ A )
     => ( ( ( power_power_nat @ A @ M )
          = ( power_power_nat @ A @ N ) )
        = ( M = N ) ) ) ).

% power_inject_exp
thf(fact_178_power__one__right,axiom,
    ! [A: real] :
      ( ( power_power_real @ A @ one_one_nat )
      = A ) ).

% power_one_right
thf(fact_179_power__one__right,axiom,
    ! [A: nat] :
      ( ( power_power_nat @ A @ one_one_nat )
      = A ) ).

% power_one_right
thf(fact_180_divide__eq__0__iff,axiom,
    ! [A: real,B: real] :
      ( ( ( divide_divide_real @ A @ B )
        = zero_zero_real )
      = ( ( A = zero_zero_real )
        | ( B = zero_zero_real ) ) ) ).

% divide_eq_0_iff
thf(fact_181_divide__cancel__left,axiom,
    ! [C2: real,A: real,B: real] :
      ( ( ( divide_divide_real @ C2 @ A )
        = ( divide_divide_real @ C2 @ B ) )
      = ( ( C2 = zero_zero_real )
        | ( A = B ) ) ) ).

% divide_cancel_left
thf(fact_182_divide__cancel__right,axiom,
    ! [A: real,C2: real,B: real] :
      ( ( ( divide_divide_real @ A @ C2 )
        = ( divide_divide_real @ B @ C2 ) )
      = ( ( C2 = zero_zero_real )
        | ( A = B ) ) ) ).

% divide_cancel_right
thf(fact_183_division__ring__divide__zero,axiom,
    ! [A: real] :
      ( ( divide_divide_real @ A @ zero_zero_real )
      = zero_zero_real ) ).

% division_ring_divide_zero
thf(fact_184_power__one,axiom,
    ! [N: nat] :
      ( ( power_power_int @ one_one_int @ N )
      = one_one_int ) ).

% power_one
thf(fact_185_power__one,axiom,
    ! [N: nat] :
      ( ( power_power_real @ one_one_real @ N )
      = one_one_real ) ).

% power_one
thf(fact_186_power__one,axiom,
    ! [N: nat] :
      ( ( power_power_nat @ one_one_nat @ N )
      = one_one_nat ) ).

% power_one
thf(fact_187_nat__zero__less__power__iff,axiom,
    ! [X: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( power_power_nat @ X @ N ) )
      = ( ( ord_less_nat @ zero_zero_nat @ X )
        | ( N = zero_zero_nat ) ) ) ).

% nat_zero_less_power_iff
thf(fact_188_abs__divide,axiom,
    ! [A: real,B: real] :
      ( ( abs_abs_real @ ( divide_divide_real @ A @ B ) )
      = ( divide_divide_real @ ( abs_abs_real @ A ) @ ( abs_abs_real @ B ) ) ) ).

% abs_divide
thf(fact_189_divide__eq__1__iff,axiom,
    ! [A: real,B: real] :
      ( ( ( divide_divide_real @ A @ B )
        = one_one_real )
      = ( ( B != zero_zero_real )
        & ( A = B ) ) ) ).

% divide_eq_1_iff
thf(fact_190_one__eq__divide__iff,axiom,
    ! [A: real,B: real] :
      ( ( one_one_real
        = ( divide_divide_real @ A @ B ) )
      = ( ( B != zero_zero_real )
        & ( A = B ) ) ) ).

% one_eq_divide_iff
thf(fact_191_divide__self,axiom,
    ! [A: real] :
      ( ( A != zero_zero_real )
     => ( ( divide_divide_real @ A @ A )
        = one_one_real ) ) ).

% divide_self
thf(fact_192_divide__self__if,axiom,
    ! [A: real] :
      ( ( ( A = zero_zero_real )
       => ( ( divide_divide_real @ A @ A )
          = zero_zero_real ) )
      & ( ( A != zero_zero_real )
       => ( ( divide_divide_real @ A @ A )
          = one_one_real ) ) ) ).

% divide_self_if
thf(fact_193_divide__eq__eq__1,axiom,
    ! [B: real,A: real] :
      ( ( ( divide_divide_real @ B @ A )
        = one_one_real )
      = ( ( A != zero_zero_real )
        & ( A = B ) ) ) ).

% divide_eq_eq_1
thf(fact_194_eq__divide__eq__1,axiom,
    ! [B: real,A: real] :
      ( ( one_one_real
        = ( divide_divide_real @ B @ A ) )
      = ( ( A != zero_zero_real )
        & ( A = B ) ) ) ).

% eq_divide_eq_1
thf(fact_195_one__divide__eq__0__iff,axiom,
    ! [A: real] :
      ( ( ( divide_divide_real @ one_one_real @ A )
        = zero_zero_real )
      = ( A = zero_zero_real ) ) ).

% one_divide_eq_0_iff
thf(fact_196_zero__eq__1__divide__iff,axiom,
    ! [A: real] :
      ( ( zero_zero_real
        = ( divide_divide_real @ one_one_real @ A ) )
      = ( A = zero_zero_real ) ) ).

% zero_eq_1_divide_iff
thf(fact_197_power__eq__0__iff,axiom,
    ! [A: int,N: nat] :
      ( ( ( power_power_int @ A @ N )
        = zero_zero_int )
      = ( ( A = zero_zero_int )
        & ( ord_less_nat @ zero_zero_nat @ N ) ) ) ).

% power_eq_0_iff
thf(fact_198_power__eq__0__iff,axiom,
    ! [A: real,N: nat] :
      ( ( ( power_power_real @ A @ N )
        = zero_zero_real )
      = ( ( A = zero_zero_real )
        & ( ord_less_nat @ zero_zero_nat @ N ) ) ) ).

% power_eq_0_iff
thf(fact_199_power__eq__0__iff,axiom,
    ! [A: nat,N: nat] :
      ( ( ( power_power_nat @ A @ N )
        = zero_zero_nat )
      = ( ( A = zero_zero_nat )
        & ( ord_less_nat @ zero_zero_nat @ N ) ) ) ).

% power_eq_0_iff
thf(fact_200_zabs__less__one__iff,axiom,
    ! [Z: int] :
      ( ( ord_less_int @ ( abs_abs_int @ Z ) @ one_one_int )
      = ( Z = zero_zero_int ) ) ).

% zabs_less_one_iff
thf(fact_201_nat__power__less__imp__less,axiom,
    ! [I: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ I )
     => ( ( ord_less_nat @ ( power_power_nat @ I @ M ) @ ( power_power_nat @ I @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) ).

% nat_power_less_imp_less
thf(fact_202_minus__int__code_I1_J,axiom,
    ! [K: int] :
      ( ( minus_minus_int @ K @ zero_zero_int )
      = K ) ).

% minus_int_code(1)
thf(fact_203_int__less__induct,axiom,
    ! [I: int,K: int,P3: int > $o] :
      ( ( ord_less_int @ I @ K )
     => ( ( P3 @ ( minus_minus_int @ K @ one_one_int ) )
       => ( ! [I2: int] :
              ( ( ord_less_int @ I2 @ K )
             => ( ( P3 @ I2 )
               => ( P3 @ ( minus_minus_int @ I2 @ one_one_int ) ) ) )
         => ( P3 @ I ) ) ) ) ).

% int_less_induct
thf(fact_204_linordered__field__no__lb,axiom,
    ! [X3: real] :
    ? [Y3: real] : ( ord_less_real @ Y3 @ X3 ) ).

% linordered_field_no_lb
thf(fact_205_linordered__field__no__ub,axiom,
    ! [X3: real] :
    ? [X_1: real] : ( ord_less_real @ X3 @ X_1 ) ).

% linordered_field_no_ub
thf(fact_206_power__not__zero,axiom,
    ! [A: int,N: nat] :
      ( ( A != zero_zero_int )
     => ( ( power_power_int @ A @ N )
       != zero_zero_int ) ) ).

% power_not_zero
thf(fact_207_power__not__zero,axiom,
    ! [A: real,N: nat] :
      ( ( A != zero_zero_real )
     => ( ( power_power_real @ A @ N )
       != zero_zero_real ) ) ).

% power_not_zero
thf(fact_208_power__not__zero,axiom,
    ! [A: nat,N: nat] :
      ( ( A != zero_zero_nat )
     => ( ( power_power_nat @ A @ N )
       != zero_zero_nat ) ) ).

% power_not_zero
thf(fact_209_zero__power,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( power_power_int @ zero_zero_int @ N )
        = zero_zero_int ) ) ).

% zero_power
thf(fact_210_zero__power,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( power_power_real @ zero_zero_real @ N )
        = zero_zero_real ) ) ).

% zero_power
thf(fact_211_zero__power,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( power_power_nat @ zero_zero_nat @ N )
        = zero_zero_nat ) ) ).

% zero_power
thf(fact_212_diff__divide__distrib,axiom,
    ! [A: real,B: real,C2: real] :
      ( ( divide_divide_real @ ( minus_minus_real @ A @ B ) @ C2 )
      = ( minus_minus_real @ ( divide_divide_real @ A @ C2 ) @ ( divide_divide_real @ B @ C2 ) ) ) ).

% diff_divide_distrib
thf(fact_213_power__0,axiom,
    ! [A: int] :
      ( ( power_power_int @ A @ zero_zero_nat )
      = one_one_int ) ).

% power_0
thf(fact_214_power__0,axiom,
    ! [A: real] :
      ( ( power_power_real @ A @ zero_zero_nat )
      = one_one_real ) ).

% power_0
thf(fact_215_power__0,axiom,
    ! [A: nat] :
      ( ( power_power_nat @ A @ zero_zero_nat )
      = one_one_nat ) ).

% power_0
thf(fact_216_power__divide,axiom,
    ! [A: real,B: real,N: nat] :
      ( ( power_power_real @ ( divide_divide_real @ A @ B ) @ N )
      = ( divide_divide_real @ ( power_power_real @ A @ N ) @ ( power_power_real @ B @ N ) ) ) ).

% power_divide
thf(fact_217_power__abs,axiom,
    ! [A: int,N: nat] :
      ( ( abs_abs_int @ ( power_power_int @ A @ N ) )
      = ( power_power_int @ ( abs_abs_int @ A ) @ N ) ) ).

% power_abs
thf(fact_218_power__abs,axiom,
    ! [A: real,N: nat] :
      ( ( abs_abs_real @ ( power_power_real @ A @ N ) )
      = ( power_power_real @ ( abs_abs_real @ A ) @ N ) ) ).

% power_abs
thf(fact_219_divide__neg__neg,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less_real @ X @ zero_zero_real )
     => ( ( ord_less_real @ Y2 @ zero_zero_real )
       => ( ord_less_real @ zero_zero_real @ ( divide_divide_real @ X @ Y2 ) ) ) ) ).

% divide_neg_neg
thf(fact_220_divide__neg__pos,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less_real @ X @ zero_zero_real )
     => ( ( ord_less_real @ zero_zero_real @ Y2 )
       => ( ord_less_real @ ( divide_divide_real @ X @ Y2 ) @ zero_zero_real ) ) ) ).

% divide_neg_pos
thf(fact_221_divide__pos__neg,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less_real @ zero_zero_real @ X )
     => ( ( ord_less_real @ Y2 @ zero_zero_real )
       => ( ord_less_real @ ( divide_divide_real @ X @ Y2 ) @ zero_zero_real ) ) ) ).

% divide_pos_neg
thf(fact_222_divide__pos__pos,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less_real @ zero_zero_real @ X )
     => ( ( ord_less_real @ zero_zero_real @ Y2 )
       => ( ord_less_real @ zero_zero_real @ ( divide_divide_real @ X @ Y2 ) ) ) ) ).

% divide_pos_pos
thf(fact_223_divide__less__0__iff,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ ( divide_divide_real @ A @ B ) @ zero_zero_real )
      = ( ( ( ord_less_real @ zero_zero_real @ A )
          & ( ord_less_real @ B @ zero_zero_real ) )
        | ( ( ord_less_real @ A @ zero_zero_real )
          & ( ord_less_real @ zero_zero_real @ B ) ) ) ) ).

% divide_less_0_iff
thf(fact_224_divide__less__cancel,axiom,
    ! [A: real,C2: real,B: real] :
      ( ( ord_less_real @ ( divide_divide_real @ A @ C2 ) @ ( divide_divide_real @ B @ C2 ) )
      = ( ( ( ord_less_real @ zero_zero_real @ C2 )
         => ( ord_less_real @ A @ B ) )
        & ( ( ord_less_real @ C2 @ zero_zero_real )
         => ( ord_less_real @ B @ A ) )
        & ( C2 != zero_zero_real ) ) ) ).

% divide_less_cancel
thf(fact_225_zero__less__divide__iff,axiom,
    ! [A: real,B: real] :
      ( ( ord_less_real @ zero_zero_real @ ( divide_divide_real @ A @ B ) )
      = ( ( ( ord_less_real @ zero_zero_real @ A )
          & ( ord_less_real @ zero_zero_real @ B ) )
        | ( ( ord_less_real @ A @ zero_zero_real )
          & ( ord_less_real @ B @ zero_zero_real ) ) ) ) ).

% zero_less_divide_iff
thf(fact_226_divide__strict__right__mono,axiom,
    ! [A: real,B: real,C2: real] :
      ( ( ord_less_real @ A @ B )
     => ( ( ord_less_real @ zero_zero_real @ C2 )
       => ( ord_less_real @ ( divide_divide_real @ A @ C2 ) @ ( divide_divide_real @ B @ C2 ) ) ) ) ).

% divide_strict_right_mono
thf(fact_227_divide__strict__right__mono__neg,axiom,
    ! [B: real,A: real,C2: real] :
      ( ( ord_less_real @ B @ A )
     => ( ( ord_less_real @ C2 @ zero_zero_real )
       => ( ord_less_real @ ( divide_divide_real @ A @ C2 ) @ ( divide_divide_real @ B @ C2 ) ) ) ) ).

% divide_strict_right_mono_neg
thf(fact_228_zero__less__power,axiom,
    ! [A: int,N: nat] :
      ( ( ord_less_int @ zero_zero_int @ A )
     => ( ord_less_int @ zero_zero_int @ ( power_power_int @ A @ N ) ) ) ).

% zero_less_power
thf(fact_229_zero__less__power,axiom,
    ! [A: real,N: nat] :
      ( ( ord_less_real @ zero_zero_real @ A )
     => ( ord_less_real @ zero_zero_real @ ( power_power_real @ A @ N ) ) ) ).

% zero_less_power
thf(fact_230_zero__less__power,axiom,
    ! [A: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ A )
     => ( ord_less_nat @ zero_zero_nat @ ( power_power_nat @ A @ N ) ) ) ).

% zero_less_power
thf(fact_231_right__inverse__eq,axiom,
    ! [B: real,A: real] :
      ( ( B != zero_zero_real )
     => ( ( ( divide_divide_real @ A @ B )
          = one_one_real )
        = ( A = B ) ) ) ).

% right_inverse_eq
thf(fact_232_power__0__left,axiom,
    ! [N: nat] :
      ( ( ( N = zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ N )
          = one_one_int ) )
      & ( ( N != zero_zero_nat )
       => ( ( power_power_int @ zero_zero_int @ N )
          = zero_zero_int ) ) ) ).

% power_0_left
thf(fact_233_power__0__left,axiom,
    ! [N: nat] :
      ( ( ( N = zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ N )
          = one_one_real ) )
      & ( ( N != zero_zero_nat )
       => ( ( power_power_real @ zero_zero_real @ N )
          = zero_zero_real ) ) ) ).

% power_0_left
thf(fact_234_power__0__left,axiom,
    ! [N: nat] :
      ( ( ( N = zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ N )
          = one_one_nat ) )
      & ( ( N != zero_zero_nat )
       => ( ( power_power_nat @ zero_zero_nat @ N )
          = zero_zero_nat ) ) ) ).

% power_0_left
thf(fact_235_power__less__imp__less__exp,axiom,
    ! [A: int,M: nat,N: nat] :
      ( ( ord_less_int @ one_one_int @ A )
     => ( ( ord_less_int @ ( power_power_int @ A @ M ) @ ( power_power_int @ A @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) ).

% power_less_imp_less_exp
thf(fact_236_power__less__imp__less__exp,axiom,
    ! [A: real,M: nat,N: nat] :
      ( ( ord_less_real @ one_one_real @ A )
     => ( ( ord_less_real @ ( power_power_real @ A @ M ) @ ( power_power_real @ A @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) ).

% power_less_imp_less_exp
thf(fact_237_power__less__imp__less__exp,axiom,
    ! [A: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ one_one_nat @ A )
     => ( ( ord_less_nat @ ( power_power_nat @ A @ M ) @ ( power_power_nat @ A @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) ).

% power_less_imp_less_exp
thf(fact_238_power__strict__increasing,axiom,
    ! [N: nat,N4: nat,A: int] :
      ( ( ord_less_nat @ N @ N4 )
     => ( ( ord_less_int @ one_one_int @ A )
       => ( ord_less_int @ ( power_power_int @ A @ N ) @ ( power_power_int @ A @ N4 ) ) ) ) ).

% power_strict_increasing
thf(fact_239_power__strict__increasing,axiom,
    ! [N: nat,N4: nat,A: real] :
      ( ( ord_less_nat @ N @ N4 )
     => ( ( ord_less_real @ one_one_real @ A )
       => ( ord_less_real @ ( power_power_real @ A @ N ) @ ( power_power_real @ A @ N4 ) ) ) ) ).

% power_strict_increasing
thf(fact_240_power__strict__increasing,axiom,
    ! [N: nat,N4: nat,A: nat] :
      ( ( ord_less_nat @ N @ N4 )
     => ( ( ord_less_nat @ one_one_nat @ A )
       => ( ord_less_nat @ ( power_power_nat @ A @ N ) @ ( power_power_nat @ A @ N4 ) ) ) ) ).

% power_strict_increasing
thf(fact_241_one__less__power,axiom,
    ! [A: int,N: nat] :
      ( ( ord_less_int @ one_one_int @ A )
     => ( ( ord_less_nat @ zero_zero_nat @ N )
       => ( ord_less_int @ one_one_int @ ( power_power_int @ A @ N ) ) ) ) ).

% one_less_power
thf(fact_242_one__less__power,axiom,
    ! [A: real,N: nat] :
      ( ( ord_less_real @ one_one_real @ A )
     => ( ( ord_less_nat @ zero_zero_nat @ N )
       => ( ord_less_real @ one_one_real @ ( power_power_real @ A @ N ) ) ) ) ).

% one_less_power
thf(fact_243_one__less__power,axiom,
    ! [A: nat,N: nat] :
      ( ( ord_less_nat @ one_one_nat @ A )
     => ( ( ord_less_nat @ zero_zero_nat @ N )
       => ( ord_less_nat @ one_one_nat @ ( power_power_nat @ A @ N ) ) ) ) ).

% one_less_power
thf(fact_244_power__one__over,axiom,
    ! [A: real,N: nat] :
      ( ( power_power_real @ ( divide_divide_real @ one_one_real @ A ) @ N )
      = ( divide_divide_real @ one_one_real @ ( power_power_real @ A @ N ) ) ) ).

% power_one_over
thf(fact_245_nonzero__abs__divide,axiom,
    ! [B: real,A: real] :
      ( ( B != zero_zero_real )
     => ( ( abs_abs_real @ ( divide_divide_real @ A @ B ) )
        = ( divide_divide_real @ ( abs_abs_real @ A ) @ ( abs_abs_real @ B ) ) ) ) ).

% nonzero_abs_divide
thf(fact_246_divide__less__eq__1,axiom,
    ! [B: real,A: real] :
      ( ( ord_less_real @ ( divide_divide_real @ B @ A ) @ one_one_real )
      = ( ( ( ord_less_real @ zero_zero_real @ A )
          & ( ord_less_real @ B @ A ) )
        | ( ( ord_less_real @ A @ zero_zero_real )
          & ( ord_less_real @ A @ B ) )
        | ( A = zero_zero_real ) ) ) ).

% divide_less_eq_1
thf(fact_247_less__divide__eq__1,axiom,
    ! [B: real,A: real] :
      ( ( ord_less_real @ one_one_real @ ( divide_divide_real @ B @ A ) )
      = ( ( ( ord_less_real @ zero_zero_real @ A )
          & ( ord_less_real @ A @ B ) )
        | ( ( ord_less_real @ A @ zero_zero_real )
          & ( ord_less_real @ B @ A ) ) ) ) ).

% less_divide_eq_1
thf(fact_248_power__strict__decreasing,axiom,
    ! [N: nat,N4: nat,A: int] :
      ( ( ord_less_nat @ N @ N4 )
     => ( ( ord_less_int @ zero_zero_int @ A )
       => ( ( ord_less_int @ A @ one_one_int )
         => ( ord_less_int @ ( power_power_int @ A @ N4 ) @ ( power_power_int @ A @ N ) ) ) ) ) ).

% power_strict_decreasing
thf(fact_249_power__strict__decreasing,axiom,
    ! [N: nat,N4: nat,A: real] :
      ( ( ord_less_nat @ N @ N4 )
     => ( ( ord_less_real @ zero_zero_real @ A )
       => ( ( ord_less_real @ A @ one_one_real )
         => ( ord_less_real @ ( power_power_real @ A @ N4 ) @ ( power_power_real @ A @ N ) ) ) ) ) ).

% power_strict_decreasing
thf(fact_250_power__strict__decreasing,axiom,
    ! [N: nat,N4: nat,A: nat] :
      ( ( ord_less_nat @ N @ N4 )
     => ( ( ord_less_nat @ zero_zero_nat @ A )
       => ( ( ord_less_nat @ A @ one_one_nat )
         => ( ord_less_nat @ ( power_power_nat @ A @ N4 ) @ ( power_power_nat @ A @ N ) ) ) ) ) ).

% power_strict_decreasing
thf(fact_251_abs__div__pos,axiom,
    ! [Y2: real,X: real] :
      ( ( ord_less_real @ zero_zero_real @ Y2 )
     => ( ( divide_divide_real @ ( abs_abs_real @ X ) @ Y2 )
        = ( abs_abs_real @ ( divide_divide_real @ X @ Y2 ) ) ) ) ).

% abs_div_pos
thf(fact_252_Rats__abs__iff,axiom,
    ! [X: real] :
      ( ( member_real @ ( abs_abs_real @ X ) @ field_1537545994s_real )
      = ( member_real @ X @ field_1537545994s_real ) ) ).

% Rats_abs_iff
thf(fact_253_Liouville__Numbers__Misc_ORats__cases_H,axiom,
    ! [X: real] :
      ( ( member_real @ X @ field_1537545994s_real )
     => ~ ! [P5: int,Q4: int] :
            ( ( ord_less_int @ zero_zero_int @ Q4 )
           => ( X
             != ( divide_divide_real @ ( ring_1_of_int_real @ P5 ) @ ( ring_1_of_int_real @ Q4 ) ) ) ) ) ).

% Liouville_Numbers_Misc.Rats_cases'
thf(fact_254_realpow__pos__nth,axiom,
    ! [N: nat,A: real] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( ord_less_real @ zero_zero_real @ A )
       => ? [R: real] :
            ( ( ord_less_real @ zero_zero_real @ R )
            & ( ( power_power_real @ R @ N )
              = A ) ) ) ) ).

% realpow_pos_nth
thf(fact_255_realpow__pos__nth__unique,axiom,
    ! [N: nat,A: real] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( ord_less_real @ zero_zero_real @ A )
       => ? [X4: real] :
            ( ( ord_less_real @ zero_zero_real @ X4 )
            & ( ( power_power_real @ X4 @ N )
              = A )
            & ! [Y4: real] :
                ( ( ( ord_less_real @ zero_zero_real @ Y4 )
                  & ( ( power_power_real @ Y4 @ N )
                    = A ) )
               => ( Y4 = X4 ) ) ) ) ) ).

% realpow_pos_nth_unique
thf(fact_256_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ N @ one_one_nat )
      = ( N = zero_zero_nat ) ) ).

% less_one
thf(fact_257_diff__self__eq__0,axiom,
    ! [M: nat] :
      ( ( minus_minus_nat @ M @ M )
      = zero_zero_nat ) ).

% diff_self_eq_0
thf(fact_258_diff__0__eq__0,axiom,
    ! [N: nat] :
      ( ( minus_minus_nat @ zero_zero_nat @ N )
      = zero_zero_nat ) ).

% diff_0_eq_0
thf(fact_259_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A: nat] :
      ( ( A != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ A ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_260_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_nat_zero_code
thf(fact_261_zero__less__diff,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( minus_minus_nat @ N @ M ) )
      = ( ord_less_nat @ M @ N ) ) ).

% zero_less_diff
thf(fact_262_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% neq0_conv
thf(fact_263_minus__nat_Odiff__0,axiom,
    ! [M: nat] :
      ( ( minus_minus_nat @ M @ zero_zero_nat )
      = M ) ).

% minus_nat.diff_0
thf(fact_264_diffs0__imp__equal,axiom,
    ! [M: nat,N: nat] :
      ( ( ( minus_minus_nat @ M @ N )
        = zero_zero_nat )
     => ( ( ( minus_minus_nat @ N @ M )
          = zero_zero_nat )
       => ( M = N ) ) ) ).

% diffs0_imp_equal
thf(fact_265_less__imp__diff__less,axiom,
    ! [J: nat,K: nat,N: nat] :
      ( ( ord_less_nat @ J @ K )
     => ( ord_less_nat @ ( minus_minus_nat @ J @ N ) @ K ) ) ).

% less_imp_diff_less
thf(fact_266_linorder__neqE__nat,axiom,
    ! [X: nat,Y2: nat] :
      ( ( X != Y2 )
     => ( ~ ( ord_less_nat @ X @ Y2 )
       => ( ord_less_nat @ Y2 @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_267_infinite__descent,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P3 @ N2 )
         => ? [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
              & ~ ( P3 @ M2 ) ) )
     => ( P3 @ N ) ) ).

% infinite_descent
thf(fact_268_nat__less__induct,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
             => ( P3 @ M2 ) )
         => ( P3 @ N2 ) )
     => ( P3 @ N ) ) ).

% nat_less_induct
thf(fact_269_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_270_diff__less__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ( ord_less_nat @ M @ L )
       => ( ord_less_nat @ ( minus_minus_nat @ L @ N ) @ ( minus_minus_nat @ L @ M ) ) ) ) ).

% diff_less_mono2
thf(fact_271_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less_nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_272_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_273_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_not_refl
thf(fact_274_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less_nat @ M @ N )
        | ( ord_less_nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_275_field__lbound__gt__zero,axiom,
    ! [D1: real,D2: real] :
      ( ( ord_less_real @ zero_zero_real @ D1 )
     => ( ( ord_less_real @ zero_zero_real @ D2 )
       => ? [E: real] :
            ( ( ord_less_real @ zero_zero_real @ E )
            & ( ord_less_real @ E @ D1 )
            & ( ord_less_real @ E @ D2 ) ) ) ) ).

% field_lbound_gt_zero
thf(fact_276_bot__nat__0_Oextremum__strict,axiom,
    ! [A: nat] :
      ~ ( ord_less_nat @ A @ zero_zero_nat ) ).

% bot_nat_0.extremum_strict
thf(fact_277_infinite__descent0,axiom,
    ! [P3: nat > $o,N: nat] :
      ( ( P3 @ zero_zero_nat )
     => ( ! [N2: nat] :
            ( ( ord_less_nat @ zero_zero_nat @ N2 )
           => ( ~ ( P3 @ N2 )
             => ? [M2: nat] :
                  ( ( ord_less_nat @ M2 @ N2 )
                  & ~ ( P3 @ M2 ) ) ) )
       => ( P3 @ N ) ) ) ).

% infinite_descent0
thf(fact_278_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not0
thf(fact_279_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_zeroE
thf(fact_280_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less0
thf(fact_281_diff__less,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( ord_less_nat @ zero_zero_nat @ M )
       => ( ord_less_nat @ ( minus_minus_nat @ M @ N ) @ M ) ) ) ).

% diff_less
thf(fact_282_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr0
thf(fact_283_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr0I
thf(fact_284_Rats__dense__in__real,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less_real @ X @ Y2 )
     => ? [X4: real] :
          ( ( member_real @ X4 @ field_1537545994s_real )
          & ( ord_less_real @ X @ X4 )
          & ( ord_less_real @ X4 @ Y2 ) ) ) ).

% Rats_dense_in_real
thf(fact_285_Rats__no__bot__less,axiom,
    ! [X: real] :
    ? [X4: real] :
      ( ( member_real @ X4 @ field_1537545994s_real )
      & ( ord_less_real @ X4 @ X ) ) ).

% Rats_no_bot_less
thf(fact_286_real__arch__pow,axiom,
    ! [X: real,Y2: real] :
      ( ( ord_less_real @ one_one_real @ X )
     => ? [N2: nat] : ( ord_less_real @ Y2 @ ( power_power_real @ X @ N2 ) ) ) ).

% real_arch_pow
thf(fact_287_real__arch__pow__inv,axiom,
    ! [Y2: real,X: real] :
      ( ( ord_less_real @ zero_zero_real @ Y2 )
     => ( ( ord_less_real @ X @ one_one_real )
       => ? [N2: nat] : ( ord_less_real @ ( power_power_real @ X @ N2 ) @ Y2 ) ) ) ).

% real_arch_pow_inv
thf(fact_288_div__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ( divide_divide_nat @ M @ N )
        = zero_zero_nat ) ) ).

% div_less
thf(fact_289_bits__div__by__1,axiom,
    ! [A: nat] :
      ( ( divide_divide_nat @ A @ one_one_nat )
      = A ) ).

% bits_div_by_1
thf(fact_290_bits__div__by__1,axiom,
    ! [A: int] :
      ( ( divide_divide_int @ A @ one_one_int )
      = A ) ).

% bits_div_by_1
thf(fact_291_bits__div__by__0,axiom,
    ! [A: nat] :
      ( ( divide_divide_nat @ A @ zero_zero_nat )
      = zero_zero_nat ) ).

% bits_div_by_0
thf(fact_292_bits__div__by__0,axiom,
    ! [A: int] :
      ( ( divide_divide_int @ A @ zero_zero_int )
      = zero_zero_int ) ).

% bits_div_by_0
thf(fact_293_bits__div__0,axiom,
    ! [A: nat] :
      ( ( divide_divide_nat @ zero_zero_nat @ A )
      = zero_zero_nat ) ).

% bits_div_0
thf(fact_294_bits__div__0,axiom,
    ! [A: int] :
      ( ( divide_divide_int @ zero_zero_int @ A )
      = zero_zero_int ) ).

% bits_div_0
thf(fact_295_diff__commute,axiom,
    ! [I: nat,J: nat,K: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ I @ J ) @ K )
      = ( minus_minus_nat @ ( minus_minus_nat @ I @ K ) @ J ) ) ).

% diff_commute
thf(fact_296_Euclidean__Division_Odiv__eq__0__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ( divide_divide_nat @ M @ N )
        = zero_zero_nat )
      = ( ( ord_less_nat @ M @ N )
        | ( N = zero_zero_nat ) ) ) ).

% Euclidean_Division.div_eq_0_iff
thf(fact_297_div__less__dividend,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ one_one_nat @ N )
     => ( ( ord_less_nat @ zero_zero_nat @ M )
       => ( ord_less_nat @ ( divide_divide_nat @ M @ N ) @ M ) ) ) ).

% div_less_dividend
thf(fact_298_div__eq__dividend__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ M )
     => ( ( ( divide_divide_nat @ M @ N )
          = M )
        = ( N = one_one_nat ) ) ) ).

% div_eq_dividend_iff
thf(fact_299_around__zero_Oinduct,axiom,
    ! [P3: int > $o,A0: int] :
      ( ! [I2: int] :
          ( ( ~ ( ord_less_int @ I2 @ zero_zero_int )
           => ( ( I2 != zero_zero_int )
             => ( P3 @ ( minus_minus_int @ I2 @ one_one_int ) ) ) )
         => ( P3 @ I2 ) )
     => ( P3 @ A0 ) ) ).

% around_zero.induct
thf(fact_300_lemma__interval__lt,axiom,
    ! [A: real,X: real,B: real] :
      ( ( ord_less_real @ A @ X )
     => ( ( ord_less_real @ X @ B )
       => ? [D3: real] :
            ( ( ord_less_real @ zero_zero_real @ D3 )
            & ! [Y4: real] :
                ( ( ord_less_real @ ( abs_abs_real @ ( minus_minus_real @ X @ Y4 ) ) @ D3 )
               => ( ( ord_less_real @ A @ Y4 )
                  & ( ord_less_real @ Y4 @ B ) ) ) ) ) ) ).

% lemma_interval_lt
thf(fact_301_int__div__less__self,axiom,
    ! [X: int,K: int] :
      ( ( ord_less_int @ zero_zero_int @ X )
     => ( ( ord_less_int @ one_one_int @ K )
       => ( ord_less_int @ ( divide_divide_int @ X @ K ) @ X ) ) ) ).

% int_div_less_self
thf(fact_302__092_060open_0621_A_P_Areal__of__int_A_Iq_Am_J_A_094_Am_A_061_A1_A_P_Areal__of__int_A_Iq_Am_J_A_094_Ar_A_K_A_I1_A_P_Areal__of__int_A_Iq_Am_J_A_094_An_J_092_060close_062,axiom,
    ( ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( q @ m ) ) @ m ) )
    = ( times_times_real @ ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( q @ m ) ) @ r ) ) @ ( divide_divide_real @ one_one_real @ ( power_power_real @ ( ring_1_of_int_real @ ( q @ m ) ) @ n ) ) ) ) ).

% \<open>1 / real_of_int (q m) ^ m = 1 / real_of_int (q m) ^ r * (1 / real_of_int (q m) ^ n)\<close>
thf(fact_303_mult__cancel__right,axiom,
    ! [A: int,C2: int,B: int] :
      ( ( ( times_times_int @ A @ C2 )
        = ( times_times_int @ B @ C2 ) )
      = ( ( C2 = zero_zero_int )
        | ( A = B ) ) ) ).

% mult_cancel_right
thf(fact_304_mult__cancel__right,axiom,
    ! [A: nat,C2: nat,B: nat] :
      ( ( ( times_times_nat @ A @ C2 )
        = ( times_times_nat @ B @ C2 ) )
      = ( ( C2 = zero_zero_nat )
        | ( A = B ) ) ) ).

% mult_cancel_right
thf(fact_305_mult__cancel__right,axiom,
    ! [A: real,C2: real,B: real] :
      ( ( ( times_times_real @ A @ C2 )
        = ( times_times_real @ B @ C2 ) )
      = ( ( C2 = zero_zero_real )
        | ( A = B ) ) ) ).

% mult_cancel_right
thf(fact_306_mult__cancel__left,axiom,
    ! [C2: int,A: int,B: int] :
      ( ( ( times_times_int @ C2 @ A )
        = ( times_times_int @ C2 @ B ) )
      = ( ( C2 = zero_zero_int )
        | ( A = B ) ) ) ).

% mult_cancel_left
thf(fact_307_mult__cancel__left,axiom,
    ! [C2: nat,A: nat,B: nat] :
      ( ( ( times_times_nat @ C2 @ A )
        = ( times_times_nat @ C2 @ B ) )
      = ( ( C2 = zero_zero_nat )
        | ( A = B ) ) ) ).

% mult_cancel_left
thf(fact_308_mult__cancel__left,axiom,
    ! [C2: real,A: real,B: real] :
      ( ( ( times_times_real @ C2 @ A )
        = ( times_times_real @ C2 @ B ) )
      = ( ( C2 = zero_zero_real )
        | ( A = B ) ) ) ).

% mult_cancel_left
thf(fact_309_mult__eq__0__iff,axiom,
    ! [A: int,B: int] :
      ( ( ( times_times_int @ A @ B )
        = zero_zero_int )
      = ( ( A = zero_zero_int )
        | ( B = zero_zero_int ) ) ) ).

% mult_eq_0_iff
thf(fact_310_mult__eq__0__iff,axiom,
    ! [A: nat,B: nat] :
      ( ( ( times_times_nat @ A @ B )
        = zero_zero_nat )
      = ( ( A = zero_zero_nat )
        | ( B = zero_zero_nat ) ) ) ).

% mult_eq_0_iff
thf(fact_311_mult__eq__0__iff,axiom,
    ! [A: real,B: real] :
      ( ( ( times_times_real @ A @ B )
        = zero_zero_real )
      = ( ( A = zero_zero_real )
        | ( B = zero_zero_real ) ) ) ).

% mult_eq_0_iff
thf(fact_312_mult__zero__right,axiom,
    ! [A: int] :
      ( ( times_times_int @ A @ zero_zero_int )
      = zero_zero_int ) ).

% mult_zero_right
thf(fact_313_mult__zero__right,axiom,
    ! [A: nat] :
      ( ( times_times_nat @ A @ zero_zero_nat )
      = zero_zero_nat ) ).

% mult_zero_right
thf(fact_314_mult__zero__right,axiom,
    ! [A: real] :
      ( ( times_times_real @ A @ zero_zero_real )
      = zero_zero_real ) ).

% mult_zero_right
thf(fact_315_mult__zero__left,axiom,
    ! [A: int] :
      ( ( times_times_int @ zero_zero_int @ A )
      = zero_zero_int ) ).

% mult_zero_left
thf(fact_316_mult__zero__left,axiom,
    ! [A: nat] :
      ( ( times_times_nat @ zero_zero_nat @ A )
      = zero_zero_nat ) ).

% mult_zero_left
thf(fact_317_mult__zero__left,axiom,
    ! [A: real] :
      ( ( times_times_real @ zero_zero_real @ A )
      = zero_zero_real ) ).

% mult_zero_left
thf(fact_318_mult_Oright__neutral,axiom,
    ! [A: int] :
      ( ( times_times_int @ A @ one_one_int )
      = A ) ).

% mult.right_neutral
thf(fact_319_mult_Oright__neutral,axiom,
    ! [A: nat] :
      ( ( times_times_nat @ A @ one_one_nat )
      = A ) ).

% mult.right_neutral
thf(fact_320_mult_Oright__neutral,axiom,
    ! [A: real] :
      ( ( times_times_real @ A @ one_one_real )
      = A ) ).

% mult.right_neutral
thf(fact_321_mult_Oleft__neutral,axiom,
    ! [A: int] :
      ( ( times_times_int @ one_one_int @ A )
      = A ) ).

% mult.left_neutral
thf(fact_322_mult_Oleft__neutral,axiom,
    ! [A: nat] :
      ( ( times_times_nat @ one_one_nat @ A )
      = A ) ).

% mult.left_neutral
thf(fact_323_mult_Oleft__neutral,axiom,
    ! [A: real] :
      ( ( times_times_real @ one_one_real @ A )
      = A ) ).

% mult.left_neutral
thf(fact_324_times__divide__eq__left,axiom,
    ! [B: real,C2: real,A: real] :
      ( ( times_times_real @ ( divide_divide_real @ B @ C2 ) @ A )
      = ( divide_divide_real @ ( times_times_real @ B @ A ) @ C2 ) ) ).

% times_divide_eq_left
thf(fact_325_divide__divide__eq__left,axiom,
    ! [A: real,B: real,C2: real] :
      ( ( divide_divide_real @ ( divide_divide_real @ A @ B ) @ C2 )
      = ( divide_divide_real @ A @ ( times_times_real @ B @ C2 ) ) ) ).

% divide_divide_eq_left
thf(fact_326_divide__divide__eq__right,axiom,
    ! [A: real,B: real,C2: real] :
      ( ( divide_divide_real @ A @ ( divide_divide_real @ B @ C2 ) )
      = ( divide_divide_real @ ( times_times_real @ A @ C2 ) @ B ) ) ).

% divide_divide_eq_right
thf(fact_327_times__divide__eq__right,axiom,
    ! [A: real,B: real,C2: real] :
      ( ( times_times_real @ A @ ( divide_divide_real @ B @ C2 ) )
      = ( divide_divide_real @ ( times_times_real @ A @ B ) @ C2 ) ) ).

% times_divide_eq_right
thf(fact_328_abs__mult__self__eq,axiom,
    ! [A: int] :
      ( ( times_times_int @ ( abs_abs_int @ A ) @ ( abs_abs_int @ A ) )
      = ( times_times_int @ A @ A ) ) ).

% abs_mult_self_eq
thf(fact_329_abs__mult__self__eq,axiom,
    ! [A: real] :
      ( ( times_times_real @ ( abs_abs_real @ A ) @ ( abs_abs_real @ A ) )
      = ( times_times_real @ A @ A ) ) ).

% abs_mult_self_eq
thf(fact_330_of__int__mult,axiom,
    ! [W: int,Z: int] :
      ( ( ring_1_of_int_real @ ( times_times_int @ W @ Z ) )
      = ( times_times_real @ ( ring_1_of_int_real @ W ) @ ( ring_1_of_int_real @ Z ) ) ) ).

% of_int_mult
thf(fact_331_real__divide__square__eq,axiom,
    ! [R2: real,A: real] :
      ( ( divide_divide_real @ ( times_times_real @ R2 @ A ) @ ( times_times_real @ R2 @ R2 ) )
      = ( divide_divide_real @ A @ R2 ) ) ).

% real_divide_square_eq
thf(fact_332_mult__cancel__left1,axiom,
    ! [C2: int,B: int] :
      ( ( C2
        = ( times_times_int @ C2 @ B ) )
      = ( ( C2 = zero_zero_int )
        | ( B = one_one_int ) ) ) ).

% mult_cancel_left1
thf(fact_333_mult__cancel__left1,axiom,
    ! [C2: real,B: real] :
      ( ( C2
        = ( times_times_real @ C2 @ B ) )
      = ( ( C2 = zero_zero_real )
        | ( B = one_one_real ) ) ) ).

% mult_cancel_left1
thf(fact_334_mult__cancel__left2,axiom,
    ! [C2: int,A: int] :
      ( ( ( times_times_int @ C2 @ A )
        = C2 )
      = ( ( C2 = zero_zero_int )
        | ( A = one_one_int ) ) ) ).

% mult_cancel_left2
thf(fact_335_mult__cancel__left2,axiom,
    ! [C2: real,A: real] :
      ( ( ( times_times_real @ C2 @ A )
        = C2 )
      = ( ( C2 = zero_zero_real )
        | ( A = one_one_real ) ) ) ).

% mult_cancel_left2
thf(fact_336_mult__cancel__right1,axiom,
    ! [C2: int,B: int] :
      ( ( C2
        = ( times_times_int @ B @ C2 ) )
      = ( ( C2 = zero_zero_int )
        | ( B = one_one_int ) ) ) ).

% mult_cancel_right1
thf(fact_337_mult__cancel__right1,axiom,
    ! [C2: real,B: real] :
      ( ( C2
        = ( times_times_real @ B @ C2 ) )
      = ( ( C2 = zero_zero_real )
        | ( B = one_one_real ) ) ) ).

% mult_cancel_right1
thf(fact_338_mult__cancel__right2,axiom,
    ! [A: int,C2: int] :
      ( ( ( times_times_int @ A @ C2 )
        = C2 )
      = ( ( C2 = zero_zero_int )
        | ( A = one_one_int ) ) ) ).

% mult_cancel_right2
thf(fact_339_mult__cancel__right2,axiom,
    ! [A: real,C2: real] :
      ( ( ( times_times_real @ A @ C2 )
        = C2 )
      = ( ( C2 = zero_zero_real )
        | ( A = one_one_real ) ) ) ).

% mult_cancel_right2
thf(fact_340_div__mult__mult1__if,axiom,
    ! [C2: nat,A: nat,B: nat] :
      ( ( ( C2 = zero_zero_nat )
       => ( ( divide_divide_nat @ ( times_times_nat @ C2 @ A ) @ ( times_times_nat @ C2 @ B ) )
          = zero_zero_nat ) )
      & ( ( C2 != zero_zero_nat )
       => ( ( divide_divide_nat @ ( times_times_nat @ C2 @ A ) @ ( times_times_nat @ C2 @ B ) )
          = ( divide_divide_nat @ A @ B ) ) ) ) ).

% div_mult_mult1_if
thf(fact_341_div__mult__mult1__if,axiom,
    ! [C2: int,A: int,B: int] :
      ( ( ( C2 = zero_zero_int )
       => ( ( divide_divide_int @ ( times_times_int @ C2 @ A ) @ ( times_times_int @ C2 @ B ) )
          = zero_zero_int ) )
      & ( ( C2 != zero_zero_int )
       => ( ( divide_divide_int @ ( times_times_int @ C2 @ A ) @ ( times_times_int @ C2 @ B ) )
          = ( divide_divide_int @ A @ B ) ) ) ) ).

% div_mult_mult1_if
thf(fact_342_div__mult__mult2,axiom,
    ! [C2: nat,A: nat,B: nat] :
      ( ( C2 != zero_zero_nat )
     => ( ( divide_divide_nat @ ( times_times_nat @ A @ C2 ) @ ( times_times_nat @ B @ C2 ) )
        = ( divide_divide_nat @ A @ B ) ) ) ).

% div_mult_mult2
thf(fact_343_div__mult__mult2,axiom,
    ! [C2: int,A: int,B: int] :
      ( ( C2 != zero_zero_int )
     => ( ( divide_divide_int @ ( times_times_int @ A @ C2 ) @ ( times_times_int @ B @ C2 ) )
        = ( divide_divide_int @ A @ B ) ) ) ).

% div_mult_mult2
thf(fact_344_div__mult__mult1,axiom,
    ! [C2: nat,A: nat,B: nat] :
      ( ( C2 != zero_zero_nat )
     => ( ( divide_divide_nat @ ( times_times_nat @ C2 @ A ) @ ( times_times_nat @ C2 @ B ) )
        = ( divide_divide_nat @ A @ B ) ) ) ).

% div_mult_mult1
thf(fact_345_div__mult__mult1,axiom,
    ! [C2: int,A: int,B: int] :
      ( ( C2 != zero_zero_int )
     => ( ( divide_divide_int @ ( times_times_int @ C2 @ A ) @ ( times_times_int @ C2 @ B ) )
        = ( divide_divide_int @ A @ B ) ) ) ).

% div_mult_mult1
thf(fact_346_mult__divide__mult__cancel__left__if,axiom,
    ! [C2: real,A: real,B: real] :
      ( ( ( C2 = zero_zero_real )
       => ( ( divide_divide_real @ ( times_times_real @ C2 @ A ) @ ( times_times_real @ C2 @ B ) )
          = zero_zero_real ) )
      & ( ( C2 != zero_zero_real )
       => ( ( divide_divide_real @ ( times_times_real @ C2 @ A ) @ ( times_times_real @ C2 @ B ) )
          = ( divide_divide_real @ A @ B ) ) ) ) ).

% mult_divide_mult_cancel_left_if
thf(fact_347_nonzero__mult__divide__mult__cancel__left,axiom,
    ! [C2: real,A: real,B: real] :
      ( ( C2 != zero_zero_real )
     => ( ( divide_divide_real @ ( times_times_real @ C2 @ A ) @ ( times_times_real @ C2 @ B ) )
        = ( divide_divide_real @ A @ B ) ) ) ).

% nonzero_mult_divide_mult_cancel_left
thf(fact_348_not__real__square__gt__zero,axiom,
    ! [X: real] :
      ( ( ~ ( ord_less_real @ zero_zero_real @ ( times_times_real @ X @ X ) ) )
      = ( X = zero_zero_real ) ) ).

% not_real_square_gt_zero

% Conjectures (1)
thf(conj_0,conjecture,
    $false ).

%------------------------------------------------------------------------------
